﻿var contexts = {
    datatable: null,    
    refreshPage: function () {
        window.location = window.location;
    },
    refreshDataTable: function () {
        contexts.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-contexts").a4datatable({
            ajaxAction: a4.getAction("GetContexts", "MultiMode", "Admin"),
            columns: [
                { "Data": "Id", "Title": resources.Id },
                { "Data": "Name", "Title": resources.Name },
                { "Data": "ClientId", "Title": resources.ClientId },
                { "Data": "ClientName", "Title": resources.ClientName },
                { "Data": "SynchronizationDate", "Title": resources.SynchronizationDate }
            ],
            defaultSorting: "Id",
            contextMenuItems: [
                { "Action": "edit", "Label": resources.Edit },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "syncusers", "Label": resources.SyncUsers, "DisplayCondition": function (data) { return data.ClientId != null && data.SynchronizationDate == null; } },
                { "Action": "syncreporting", "Label": resources.SyncReporting, "DisplayCondition": function (data) { return data.ClientId != null; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        modalDialog.showWindow(a4.getAction("ContextEditor", "MultiMode", "Admin", { id: row.Id }), 700, 650, {
                            afterClose: function () {
                                contexts.refreshDataTable();
                            }
                        });
                        break;
                    case "delete":
                        contexts.deleteContext(row.Id, row.Name);
                        break;
                    case "syncusers":
                        a4.callServerMethod(a4.getAction("SynchronizeUsersAndGroups", "MultiMode", "Admin"), { contextId: row.Id, clientId: row.ClientId }, function (result) {
                            contexts.refreshPage();
                        });
                        break;
                    case "syncreporting":
                        a4.callServerMethod(a4.getAction("SynchronizePortal", "MultiMode", "Admin"), { contextId: row.Id, clientId: row.ClientId }, function (result) {
                            contexts.refreshPage();
                        });
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addContext", function () {
            modalDialog.showWindow(a4.getAction("ContextEditor", "MultiMode", "Admin"), 700, 650, {
                afterClose: function () {
                    contexts.refreshDataTable();
                }
            });
        });
    },
    deleteContext: function (id, name) {
        modalDialog.showConfirmDialog(confirmDeleteResources, function () {
            a4.callServerMethod(a4.getAction("DeleteContext", "MultiMode", "Admin"), { id: id, name: name },
                function (result) {
                    if (result.success)
                        contexts.refreshPage();
                    else
                        a4.showErrorMessage(result.message);
                });
        }, null, null, true, { "name": name });
    }
}

$(document).ready(function () {
    if ($(".v-contexts").length > 0) {
        a4.busyBoxEnabled = true;        
        contexts.initializeDataTable();
        contexts.bindEvents();
    }
});